const jwt = require("jsonwebtoken");

const auth = async (req, res, next) => {
  try {
    const token = req.header("Authorization").replace("Bearer ", "");
    if (!token) {
      return res
        .status(401)
        .json({ message: "Authorization token is required" });
    }
    const PRIVATE_KEY = process.env.PRIVATE_KEY.replace(/\\n/g, "\n");
    const decoded = jwt.verify(token, PRIVATE_KEY); 
    const currentTime = Math.floor(Date.now() / 1000);
    if (decoded.exp && decoded.exp < currentTime) {
      const res = { message: "Token has expired." };
      req.user = res;
    } else {
      req.user = decoded;
    }
    next(); 
  } catch (err) {
    res
      .status(401)
      .json({ message: "Invalid or expired token", error: err.message });
  }
};

module.exports = auth;
