const db = require("../config/db");
const redis = require("../config/redis");

class CountryRegion {
  // 🟢 Create Clients Table

  static async getAll() {
    const cachedCountries = await redis.get("countries:all");
    if (cachedCountries) {
      return JSON.parse(cachedCountries);
    }

    const { rows } = await db.query("SELECT * FROM countries");
    await redis.setex("countries:all", 3600, JSON.stringify(rows)); // Cache for 1 hour
    return rows;
  }

  static async getById(country_id) {
    const cachedRegions = await redis.get(`regions:${country_id}`);
    if (cachedRegions) {
      return JSON.parse(cachedRegions);
    }

    const {
      rows,
    } = await db.query("SELECT * FROM regions WHERE country_id = $1", [
      country_id,
    ]);

    if (rows.length === 0) return null;

    await redis.setex(`regions:${country_id}`, 3600, JSON.stringify(rows));
    return rows;
  }
}

module.exports = CountryRegion;
