const db = require("../config/db");
const redis = require("../config/redis");

class User {
  static async findByEmail(email) {
    const cachedUser = await redis.get(`users:${email}`);
    if (cachedUser) {
      return JSON.parse(cachedUser);
    }
    const { rows } = await db.query(
      "SELECT * FROM users WHERE email = $1 OR username = $1 LIMIT 1",
      [email]
    );
    if (rows.length === 0) return null;
    const user = rows[0];
    await redis.setex(`users:${email}`, 3600, JSON.stringify(user));
    return user;
  }
  static async create(username, email, password, role) {
    const { rows } = await db.query(
      "INSERT INTO users (username, email, password, role) VALUES ($1, $2, $3, $4) RETURNING id",
      [username, email, password, role]
    );
    return rows[0].id;
  }
  static async updateToken(email, token) {
    const { rows } = await db.query(
      "UPDATE users SET token=$1 WHERE email=$2 OR username=$2 RETURNING id",
      [token, email]
    );
    await redis.del(`users:${email}`);
    return rows[0].id;
  }
}
module.exports = User;
