const express = require("express");
const bcrypt = require("bcryptjs");
const jwt = require("jsonwebtoken");
const User = require("../models/user");
const auth = require("../middleware/auth");

const router = express.Router();

// Register
router.post("/register", async (req, res) => {
  const { username, email, password, role } = req.body;

  try {
    const hashedPassword = await bcrypt.hash(password, 10);
    const userId = await User.create(username, email, hashedPassword, role);

    res.status(201).json({ message: "User registered successfully", userId });
  } catch (err) {
    res
      .status(500)
      .json({ message: "Error registering user", error: err.message });
  }
});
router.post("/login", async (req, res) => {
  const { user_name, password } = req.body;
  try {
    const user = await User.findByEmail(user_name);
    if (!user || !(await bcrypt.compare(password, user.password))) {
      return res.status(400).json({ message: "Invalid credentials" });
    }
    const PRIVATE_KEY = process.env.PRIVATE_KEY.replace(/\\n/g, "\n");
    const token = jwt.sign(
      { id: user.id, email: user.email, role: user.role },
      PRIVATE_KEY,
      { expiresIn: "1d" }
    );
    return res.json({ token, status: true });
  } catch (err) {
    return res
      .status(500)
      .json({ message: "Error logging in", error: err.message });
  }
});
router.post("/logout", async (req, res) => {
  try {
    const { email } = req.body;

    if (!email) {
      return res
        .status(400)
        .json({ success: false, message: "Email is required." });
    }

    const result = await User.logout(email);

    if (!result.success) {
      return res.status(400).json(result);
    }

    res.status(200).json(result);
  } catch (error) {
    res.status(500).json({ success: false, message: error.message });
  }
});
router.post("/get-users", auth, (req, res) => {
  res.json({ message: "Token is valid!", user: req.user });
});

module.exports = router;
