const express = require("express");
const router = express.Router();
const ClientLocation = require("../models/clientLocationModel");
const auth = require("../middleware/auth");

// 🏗️ Create client location
router.post("/client/location/create", auth, async (req, res) => {
  try {
    const {
      client_id,
      client_type_id,
      // loc_id,
      fax,
      locationCity,
      locationDistName,
      locationName,
      phone,
      postCode,
      streetLine1,
      streetLine2,
      locationStatus,
    } = req.body;

    if (!client_id) {
      return res.status(400).json({ message: "client_id are required" });
    }

    const newLocation = await ClientLocation.create({
      client_id,
      client_type_id,
      // loc_id,
      fax,
      locationCity,
      locationDistName,
      locationName,
      phone,
      postCode,
      streetLine1,
      streetLine2,
      locationStatus,
    });

    res.status(201).json({
      status: true,
      message: "Client location created successfully",
      location: newLocation,
    });
  } catch (err) {
    res
      .status(500)
      .json({ message: "Error creating client location", error: err.message });
  }
});

// 📋 Get all client locations
router.get("/client/location/all", auth, async (req, res) => {
  try {
    const locations = await ClientLocation.getAll();
    res.status(200).json({ status: true, locations });
  } catch (err) {
    res
      .status(500)
      .json({ message: "Error fetching client locations", error: err.message });
  }
});

// 🔍 Get locations by client ID
router.get("/client/location/:client_id", auth, async (req, res) => {
  try {
    const { client_id } = req.params;
    const locations = await ClientLocation.getByClientId(client_id);
    res.status(200).json({ status: true, locations });
  } catch (err) {
    res
      .status(500)
      .json({ message: "Error fetching client locations", error: err.message });
  }
});

// 🔄 Update client location
router.put("/client/location/update", auth, async (req, res) => {
  try {
    const {
      client_id,
      loc_id,
      client_type_id,
      fax,
      locationCity,
      locationDistName,
      locationName,
      phone,
      postCode,
      streetLine1,
      streetLine2,
      locationStatus,
    } = req.body;

    if (!client_id || !loc_id || !client_type_id) {
      return res
        .status(400)
        .json({ message: "client_id , loc_id,client_type_id are required" });
    }

    const updatedLocation = await ClientLocation.update({
      client_id,
      loc_id,
      client_type_id,
      fax,
      locationCity,
      locationDistName,
      locationName,
      phone,
      postCode,
      streetLine1,
      streetLine2,
      locationStatus,
    });

    res.status(200).json({
      status: true,
      message: "Client location updated successfully",
      location: updatedLocation,
    });
  } catch (err) {
    res
      .status(500)
      .json({ message: "Error updating client location", error: err.message });
  }
});

// ❌ Delete client location
router.delete("/client/location/delete", auth, async (req, res) => {
  try {
    const { client_id, loc_id } = req.body;

    if (!client_id || !loc_id) {
      return res
        .status(400)
        .json({ message: "client_id and loc_id are required" });
    }

    const result = await ClientLocation.delete(client_id, loc_id);
    res.status(200).json({ status: true, message: result.message });
  } catch (err) {
    res
      .status(500)
      .json({ message: "Error deleting client location", error: err.message });
  }
});

module.exports = router;
