const express = require("express");
const router = express.Router();
const MasterPayment = require("../../models/payment_gateways/masterPaymentGateway");

// Create a new payment gateway
router.post("/payment", async (req, res) => {
  try {
    const { payment_gateway_name, url } = req.body;
    const newPayment = await MasterPayment.create({
      payment_gateway_name,
      url,
    });
    res.status(201).json({
      status: true,
      message: "Payment gateway created successfully",
      newPayment,
    });
  } catch (err) {
    res.status(500).json({ error: err.message });
  }
});

// Get all payment gateways
router.get("/payment", async (req, res) => {
  try {
    const payments = await MasterPayment.getAll();
    res.status(200).json(payments);
  } catch (err) {
    res.status(500).json({ error: err.message });
  }
});

// Get a single payment gateway by ID
router.get("/payment/:id", async (req, res) => {
  try {
    const { id } = req.params;
    const payment = await MasterPayment.getById(id);
    if (!payment)
      return res.status(404).json({ message: "Payment gateway not found" });
    res.status(200).json(payment);
  } catch (err) {
    res.status(500).json({ error: err.message });
  }
});

// Update a payment gateway
router.put("/payment/:id", async (req, res) => {
  try {
    const { id } = req.params;
    const { payment_gateway_name, url } = req.body;
    const updatedPayment = await MasterPayment.update({
      id,
      payment_gateway_name,
      url,
    });
    res.status(200).json({
      status: true,
      message: "Payment gateway updated successfully",
      updatedPayment,
    });
  } catch (err) {
    res.status(500).json({ error: err.message });
  }
});

// Delete a payment gateway
router.delete("/payment/:id", async (req, res) => {
  try {
    const { id } = req.params;
    await MasterPayment.delete(id);
    res.status(200).json({ message: "Payment gateway deleted successfully" });
  } catch (err) {
    res.status(500).json({ error: err.message });
  }
});

module.exports = router;
