const express = require("express");
const router = express.Router();
const MasterSalesChannel = require("../../models/sales_chanels/masterSalesChannel");

// Create a new sales channel
router.post("/sales-channel", async (req, res) => {
  try {
    const { channel_name, url } = req.body;
    const newChannel = await MasterSalesChannel.create({ channel_name, url });
    res.status(201).json({
      status: true,
      message: "Channel Created successfully",
      newChannel,
    });
  } catch (err) {
    res.status(500).json({ error: err.message });
  }
});

// Get all sales channels
router.get("/sales-channel", async (req, res) => {
  try {
    const channels = await MasterSalesChannel.getAll();
    res.status(200).json(channels);
  } catch (err) {
    res.status(500).json({ error: err.message });
  }
});

// Get a single sales channel by ID
router.get("/sales-channel/:channel_id", async (req, res) => {
  try {
    const { channel_id } = req.params;
    const channel = await MasterSalesChannel.getById(channel_id);
    if (!channel) return res.status(404).json({ message: "Channel not found" });
    res.status(200).json(channel);
  } catch (err) {
    res.status(500).json({ error: err.message });
  }
});

// Update a sales channel
router.put("/sales-channel/:channel_id", async (req, res) => {
  try {
    const { channel_id } = req.params;
    const { channel_name, url } = req.body;
    const updatedChannel = await MasterSalesChannel.update({
      channel_id,
      channel_name,
      url,
    });
    res.status(200).json({
      status: true,
      message: "Channel Updated successfully",
      updatedChannel,
    });
  } catch (err) {
    res.status(500).json({ error: err.message });
  }
});

// Delete a sales channel
router.delete("/sales-channel/:channel_id", async (req, res) => {
  try {
    const { channel_id } = req.params;
    await MasterSalesChannel.delete(channel_id);
    res.status(200).json({ message: "Sales channel deleted successfully" });
  } catch (err) {
    res.status(500).json({ error: err.message });
  }
});

module.exports = router;
