const express = require("express");
const router = express.Router();
const MasterShippingMethod = require("../../models/shipping_methods/masterShippingMethod");

// Create a new sales channel
router.post("/shipping-method", async (req, res) => {
  try {
    const { shipping_name, url } = req.body;
    const newShipping = await MasterShippingMethod.create({
      shipping_name,
      url,
    });
    res.status(201).json({
      status: true,
      message: "Method Created successfully",
      newShipping,
    });
  } catch (err) {
    res.status(500).json({ error: err.message });
  }
});

// Get all sales channels
router.get("/shipping-method", async (req, res) => {
  try {
    const shipping = await MasterShippingMethod.getAll();
    res.status(200).json(shipping);
  } catch (err) {
    res.status(500).json({ error: err.message });
  }
});

// Get a single sales channel by ID
router.get("/shipping-method/:shipping_id", async (req, res) => {
  try {
    const { shipping_id } = req.params;
    const shipping = await MasterShippingMethod.getById(shipping_id);
    if (!shipping)
      return res.status(404).json({ message: "Shipping not found" });
    res.status(200).json(shipping);
  } catch (err) {
    res.status(500).json({ error: err.message });
  }
});

// Update a sales channel
router.put("/shipping-method/:shipping_id", async (req, res) => {
  try {
    const { shipping_id } = req.params;
    const { shipping_name, url } = req.body;
    const updatedShipping = await MasterShippingMethod.update({
      shipping_id,
      shipping_name,
      url,
    });
    res.status(200).json({
      status: true,
      message: "Shipping Method Updated successfully",
      updatedShipping,
    });
  } catch (err) {
    res.status(500).json({ error: err.message });
  }
});

// Delete a sales channel
router.delete("/shipping-method/:shipping_id", async (req, res) => {
  try {
    const { shipping_id } = req.params;
    await MasterShippingMethod.delete(shipping_id);
    res.status(200).json({ message: "Method deleted successfully" });
  } catch (err) {
    res.status(500).json({ error: err.message });
  }
});

module.exports = router;
